/* Secvente - O(N)
 * Dana Lica
 * scor: 100
 */
#include <bits/stdc++.h>

using namespace std;

const int NMAX = 1e6 + 1;
const int INF = 1e9;

int N, K, sp[NMAX];

int V[NMAX], M;

namespace InParser
{
static const int BSIZE = (1 << 16);

static int pos = BSIZE - 1;
static char buff[BSIZE];

inline char Char ()
{
    ++pos;

    if(pos == BSIZE)
    {
        pos = 0;

        int n = fread(buff, 1, BSIZE, stdin);

        if(n != BSIZE)
            for(int i = n; i < BSIZE; ++i)
                buff[i] = 0;
    }

    return buff[pos];
}

inline int Int ()
{
    int ans = 0;

    for( ; ; )
    {
        char Ch = Char();

        if(Ch >= '0' && Ch <= '9')
        {
            ans = (int)(Ch - '0');

            break;
        }
    }

    for( ; ; )
    {
        char Ch = Char();

        if(Ch >= '0' && Ch <= '9')
            ans = ans * 10 + (int)(Ch - '0');
        else
            break;
    }

    return ans;
}
};

static inline int Query (int Left, int Right)
{
    if(Left > Right)
        return 0;

    return sp[Right] - sp[Left - 1];
}

static inline void Read ()
{
    ios_base :: sync_with_stdio(false);
    cin.tie(nullptr);

    freopen("secvente.in", "r", stdin);
    freopen("secvente.out", "w", stdout);

    N = InParser :: Int(), K = InParser :: Int();
    assert(1 <= N && N <= 1e6), assert((K << 1) <= N);

    for(int i = 1; i <= N; ++i)
    {
        char now = InParser :: Char();
        assert(now == '0' || now == '1');

        sp[i] = sp[i - 1] + (bool)(now == '1');

        if(i >= K)
            V[i - K + 1] = Query(i - K + 1, i);
    }

    return;
}

static inline int my_max (int a, int b)
{
    return ((a > b) ? a : b);
}

static inline void Precalculation ()
{
    M = (N - K + 1);

    for(int i = M - 1; i >= 1; --i)
        V[i] = my_max(V[i], V[i + 1]);

    return;
}

static inline int my_min (int a, int b)
{
    return ((a < b) ? a : b);
}

static inline void Solve ()
{
    int ans = INF;

    for(int i = 1; i <= M - K; ++i)
    {
        int j = i + K;

        ans = my_min(ans, (K << 1) - (Query(i, j - 1) + V[j]));
    }

    printf("%d\n", ans);

    return;
}

int main()
{
    Read();

    if((K << 1) > sp[N])
    {
        printf("-1\n");

        return 0;
    }

    Precalculation();

    Solve();

    return 0;
}
