/* Pitici - O(N^2)
 * Dana Lica
 * scor: 50
 */
#include <fstream>

using namespace std;

ifstream f("pitici.in");
ofstream g("pitici.out");

using ll = long long;

const int NMAX = 2e5 + 1;

int N, A[NMAX], nr[NMAX];

ll B;

static inline void Load ()
{
    f.tie(nullptr);

    f >> N;

    for(int i = 1; i <= N; ++i)
        f >> A[i];

    return;
}

static inline void Solve ()
{
    for(int i = 1; i <= N; ++i)
    {
        f >> B;

        ll sum = 0;

        for(int j = i; j <= N; ++j)
        {
            sum += 1LL * A[j], ++nr[j];

            if(sum >= B)
                break;
        }
    }

    return;
}

static inline void Write ()
{
    int ans = -1, cnt = 0;

    for(int i = 1; i <= N; ++i)
    {
        if(nr[i] > ans)
            ans = nr[i], cnt = 1;
        else if(nr[i] == ans)
            ++cnt;
    }

    g << ans << ' ' << cnt << '\n';

    return;
}

int main()
{
    Load();

    Solve();

    Write();

    return 0;
}
