/* Pitici - O(NlogN)
 * Florian Usurelu
 * scor: 100
 */
#include <bits/stdc++.h>
using namespace std;

ifstream f ("pitici.in");
ofstream g ("pitici.out");

const int nmax = 2e5 + 3;

int n;
long long a[nmax], b[nmax], sum[nmax], ms[nmax];

void read()
{
    f >> n;

    assert(n >= 1 && n <= 200000);

    for (int i = 1; i <= n; ++i)
    {
        f >> a[i];
        assert(a[i] >= 0 && a[i] <= 1e9);
    }

    for (int i = 1; i <= n; ++i)
    {
        f >> b[i];
        assert(b[i] >= 0 && b[i] <= 1e18);
    }
}

int main()
{
    read();

    for (int i = 1; i <= n; ++i)
    {
        sum[i] = sum[i - 1] + a[i];
    }

    for (int i = 1; i <= n; ++i)
    {
        int st = 1;
        int dr = n;
        int usu = n;

        while (st <= dr)
        {
            int mij = (st + dr) / 2;
            if (sum[mij] - sum[i - 1] >= b[i])
            {
                usu = mij;
                dr = mij - 1;
                continue;
            }
            else st = mij + 1;
        }

        ms[i]++;
        ms[usu + 1]--;

    }

    int Max = 0;
    int Nr = 0;

    for (int i = 1; i <= n; ++i)
    {
        ms[i] += ms[i - 1];
        if (ms[i] > Max)
        {
            Max = ms[i];
            Nr = 1;
            continue;
        }
        if(ms[i] == Max) ++Nr;
    }

    g << Max << ' ' << Nr << '\n';

    return 0;
}








