/*
 * Cmmdc - O(N*logN)
 * Dana Lica
 * scor: 100
 */
#include <iostream>
#include <fstream>


using namespace std;

ifstream f("cmmdc.in");
ofstream g("cmmdc.out");
#define f cin
#define g cout
const int NMAX = 1e6 + 1, MOD = 1e9 + 7;

int N;

int phi[NMAX];
int sum_prod[NMAX];

int sp[NMAX];

void Load ()
{
    f >> N;

    return;
}

void indicatorEuler()
{
    for(int i = 2; i <= N; ++i)
        phi[i] = (i - 1);

    for(int i = 2; i <= (N >> 1); ++i)
        if(phi[i] > 0)
            for(int j = (i << 1); j <= N; j += i)
                phi[j] -= phi[i];

    return;
}

void Multiply (int &a, long long b)
{
    a = (1LL * a * b) % (1LL * MOD);

    return;
}

void Add (int &a, int b)
{
    a = (a + b) % MOD;

    return;
}

void Initializare ()
{
    indicatorEuler();

    for(int i = 3; i <= N; ++i)
    {
        int sum = ((1LL * i * phi[i]) >> (1LL)) % (1LL * MOD);
        sum --;
        if(sum < 0) sum += MOD;

        sum_prod[i] = (1LL * sum * i) % (1LL * MOD);
    }

    for(int i = 3; i <= N; ++i) ///sume partiale ca sa ramanem in O(1) la calculul factorului pentru un c fixat
        sp[i] = sp[i - 1], Add(sp[i], sum_prod[i]);

    return;
}

void Solve ()
{
    Initializare();

    int ans = 0;

    for(int c = 1; c <= (N / 3); ++c)
    {
        int termen = 1;

        Multiply(termen, 2LL * c * c * c);
        Multiply(termen, sp[N / c]);

        Add(ans, termen);
    }

    g << ans << '\n';

    return;
}

int main()
{
    Load();

    Solve();

    return 0;
}
