#include <bits/stdc++.h>
using namespace std;

const int NMAX = 2005;

int N, col[NMAX], v[NMAX];
vector<pair<int, int>> swaps;

int main()
{
    assert(cin >> N);
    assert(3 <= N && N <= 2000);
    for (int i = 1; i <= N; ++i)
    {
        assert(cin >> col[i]);
        assert(col[i] == 1 || col[i] == 2);
    }
    for (int i = 1; i <= N; ++i)
    {
        assert(cin >> v[i]);
        assert(1 <= v[i] && v[i] <= 1000000000);
    }

    bool ok = false;
    for (int i = 2; !ok && i <= N; ++i)
        if (col[i] != col[1])
            ok = true;
    if (!ok)
    {
        ok = true;
        for (int i = 2; ok && i <= N; ++i)
            if (v[i] < v[i - 1])
                ok = false;
        cout << (ok ? 0 : -1) << '\n';
        return 0;
    }

    int last = 0;
    for (int i = 1; i < N; ++i)
    {
        int minim = i;
        for (int j = i; j <= N; ++j)
            if (v[j] < v[minim])
                minim = j;
        if (i != minim)
        {
            if (col[i] != col[minim])
            {
                swap(col[i], col[minim]);
                swap(v[i], v[minim]);
                swaps.emplace_back(i, minim);
                last = i;
            }
            else
            {
                int inter = i;
                while (inter <= N && col[inter] == col[i])
                    inter++;
                if (inter <= N)
                {
                    swap(col[i], col[inter]);
                    swap(v[i], v[inter]);
                    swaps.emplace_back(i, inter);
                    swap(col[i], col[minim]);
                    swap(v[i], v[minim]);
                    swaps.emplace_back(i, minim);
                    last = i;
                }
                else
                    break;
            }
        }
        else
        {
            last = i;
        }
    }

    if (last < N - 1)
    {
        int remain_color = col[last + 1];
        int minim = last + 1;
        for (int i = last + 1; i <= N; ++i)
            if (v[i] < v[minim])
                minim = i;
        int other = 1;
        while (col[other] == remain_color)
            other++;
        swap(col[minim], col[other]);
        swap(v[minim], v[other]);
        swaps.emplace_back(other, minim);

        int last_to_place = other;
        other = minim;

        for (int i = N; i >= last + 2; --i)
        {
            int maxim = -1;
            for (int j = i; j >= last + 1; --j)
            {
                if (col[j] != remain_color)
                    continue;
                if (maxim == -1 || v[maxim] < v[j])
                    maxim = j;
            }
            if (maxim == i)
                continue;
            if (col[maxim] != col[i])
            {
                swap(col[i], col[maxim]);
                swap(v[i], v[maxim]);
                swaps.emplace_back(maxim, i);
                other = maxim;
            }
            else
            {
                swap(col[i], col[other]);
                swap(v[i], v[other]);
                swaps.emplace_back(other, i);
                swap(col[i], col[maxim]);
                swap(v[i], v[maxim]);
                swaps.emplace_back(maxim, i);
                other = maxim;
            }
        }

        assert(other == last + 1);
        swaps.emplace_back(last_to_place, other);
    }

    cout << swaps.size() << '\n';
    for (auto &&it : swaps)
        cout << it.first << ' ' << it.second << '\n';

    cout << "  \n  \n  \n";
    return 0;
}
