#include <fstream>

using namespace std;

ifstream f("izi.in");
ofstream g("izi.out");

const int NMAX = 1e6 + 1;

int Q, M;

int N, Stack[NMAX];

class SegmentTree
{
    int V[(NMAX << 2)];
    int Lazy[(NMAX << 2)];

private:
    inline void Go (int Node, int a, int b)
    {
        if(a == b)
            return;

        if(Lazy[Node] == 0)
            return;

        V[(Node << 1)] += Lazy[Node], V[((Node << 1) + 1)] += Lazy[Node];
        Lazy[(Node << 1)] += Lazy[Node], Lazy[((Node << 1) + 1)] += Lazy[Node];

        Lazy[Node] = 0;

        return;
    }

public:
    inline void Update (int Node, int a, int b, int ua, int ub, int Val)
    {
        if(ua <= a && b <= ub)
        {
            V[Node] += Val;

            Lazy[Node] += Val;

            return;
        }

        Go(Node, a, b);

        int Mid = ((a + b) >> 1);

        if(ua <= Mid)
            Update((Node << 1), a, Mid, ua, ub, Val);

        if(ub > Mid)
            Update(((Node << 1) + 1), Mid + 1, b, ua, ub, Val);

        V[Node] = V[(Node << 1)] + V[((Node << 1) + 1)];

        return;
    }

    inline int Query (int Node, int a, int b, int qa, int qb)
    {
        if(qa <= a && b <= qb)
            return V[Node];

        Go(Node, a, b);

        int Mid = ((a + b) >> 1);
        int p_Left = 0, p_Right = 0;

        if(qa <= Mid)
            p_Left = Query((Node << 1), a, Mid, qa, qb);

        if(qb > Mid)
            p_Right = Query(((Node << 1) + 1), Mid + 1, b, qa, qb);

        return (p_Left + p_Right);
    }
} AINT;

static inline void TestCase ()
{
    short int Type = 0;
    f >> Type;

    if(Type == 0)
    {
        int X = 0;
        f >> X;

        Stack[++N] = X;

        g << X << '\n';

        return;
    }

    if(Type == 1)
    {
        int Left = 0, Right = 0, X = 0;
        f >> Left >> Right >> X;

        AINT.Update(1, 1, M, Left, Right, X);
    }
    else
    {
        int now = AINT.Query(1, 1, M, N, N);
        AINT.Update(1, 1, M, N, N, -now);

        --N;
    }

    g << Stack[N] + AINT.Query(1, 1, M, N, N) << '\n';

    return;
}

int main()
{
    f.tie(nullptr);

    f >> Q; M = Q;

    while(Q--)
        TestCase();

    return 0;
}
