/*
 * Bogdan Sitaru
 * HalfTree - O(N^3)
 */

#include <bits/stdc++.h>

using namespace std;

typedef pair<int, int> pii;
typedef long long ll;

const int NMAX = 1e5 + 5;

ll ans, cost;
int N;
int p[NMAX], c[NMAX], sz[NMAX];
vector<pii> edg[NMAX];

void DFS(int nod, int fth = 0) {
    sz[nod] = 1;
    p[nod] = fth;
    for(auto nxtEdg: edg[nod]) {
        int nxt = nxtEdg.first, val = nxtEdg.second;
        if(nxt == fth)  continue;
        c[nxt] = val;
        DFS(nxt, nod);
        sz[nod] += sz[nxt];
    }
}

void solve(int nod, int fth = 0) {
    for(auto nxtEdg: edg[nod]) {
        int nxt = nxtEdg.first;
        if(nxt == fth)  continue;
        cost += 1LL * c[nxt] * sz[nxt] * (N - sz[nxt]);
        solve(nxt, nod);
    }
}

int main() {
    cin >> N;
    for(int i = 2; i <= N; i++) cin >> p[i];
    for(int i = 2; i <= N; i++) cin >> c[i];

    for(int i = 2; i <= N; i++) {
        int x = i, y = p[i], z = c[i];
        edg[x].push_back({y, z});
        edg[y].push_back({x, z});
    }

    ans = 1LL << 60;
    for(int i = 1; i <= N; i++) {
        DFS(i);
        for (int j = i; j <= N; j++) {
            int x = j;
            while(x != i) {
                c[x] /= 2;
                x = p[x];
            }
            cost = 0;
            solve(i);
            ans = min(ans, cost);
            x = j;
            while(x != i) {
                c[x] *= 2;
                x = p[x];
            }
        }
    }

    cout << ans << '\n';
    return 0;
}