/*
 * Bogdan Sitaru
 * HalfTree - O(N^2)
 */

#include <bits/stdc++.h>

using namespace std;

typedef pair<int, int> pii;
typedef long long ll;

const int NMAX = 1e5 + 5;
const int MAX_TIME = 100;
const int TIME_STOP = MAX_TIME - 5;

ll ans, mx, tot;
int N;
int p[NMAX], c[NMAX], sz[NMAX];
vector<pii> edg[NMAX];

void DFS(int nod, int fth = 0) {
    sz[nod] = 1;
    p[nod] = fth;
    for(auto nxtEdg: edg[nod]) {
        int nxt = nxtEdg.first, val = nxtEdg.second;
        if(nxt == fth)  continue;
        c[nxt] = val;
        DFS(nxt, nod);
        sz[nod] += sz[nxt];
    }
}

void solve(int nod, int fth = 0, ll chain = 0) {
    mx = max(mx, chain);
    for(auto nxtEdg: edg[nod]) {
        int nxt = nxtEdg.first;
        if(nxt == fth)  continue;
        ll now = 1LL * c[nxt] * sz[nxt] * (N - sz[nxt]);
        tot += now;
        solve(nxt, nod, chain + now / 2);
    }
}

int main() {
    cin >> N;
    for(int i = 2; i <= N; i++) cin >> p[i];
    for(int i = 2; i <= N; i++) cin >> c[i];

    for(int i = 2; i <= N; i++) {
        int x = i, y = p[i], z = c[i];
        edg[x].push_back({y, z});
        edg[y].push_back({x, z});
    }

    ans = 1LL << 60;
    for(int i = 1; i <= N; i++) {
        tot = 0, mx = 0;
        DFS(i);
        solve(i);
        ans = min(ans, tot - mx);
    }

    cout << ans << '\n';
    return 0;
}