/*
 * Bogdan Sitaru
 * HalfTree - O(N)
 */

#include <bits/stdc++.h>

using namespace std;

typedef long long ll;

const int NMAX = 1e5 + 5;

int N;
int p[NMAX], c[NMAX];
int sz[NMAX];
ll dp[NMAX];
vector<int> edg[NMAX];

int main() {
    assert( scanf("%d", &N) == 1 );
    assert(1 <= N && N <= int(1e5));

    for(int i = 2; i <= N; i++) {
        assert( scanf("%d", &p[i]) == 1 );
        assert(1 <= p[i] && p[i] < i);
        edg[ p[i] ].push_back(i);
    }
    for(int i = 2; i <= N; i++) {
        assert( scanf("%d", &c[i]) == 1 );
        assert(int(-1e3) <= c[i] && c[i] <= int(1e3));
        assert(c[i] % 2 == 0);
    }

    for(int i = N; i >= 1; i--) {
        sz[i] = 1;
        for(auto nxt: edg[i])
            sz[i] += sz[nxt];
    }

    ll ans = 0;
    ll mx = 0;
    for(int i = N; i >= 1; i--) {
        ll mx1 = 0, mx2 = 0;
        dp[i] = 0;
        for(auto nxt: edg[i]) {
            ll now = 1LL * c[nxt] * sz[nxt] * (N - sz[nxt]);
            ans += now;
            now /= 2;
            now = max(now, now + dp[nxt]);
            if(now > mx1) {
                mx2 = mx1;
                mx1 = now;
            } else if(now > mx2)
                mx2 = now;
        }
        mx = max(mx, mx1 + mx2);
        dp[i] = mx1;
    }

    ans -= mx;
    printf("%lld\n", ans);
    return 0;
}
