// HalfTree - Tamio - 100
#include <bits/stdc++.h>
using namespace std;

constexpr int maxn = 1e5 + 10;
using ll = long long;

ll n, tt[maxn], cost[maxn], weight[maxn] = {}, best[maxn], snd_best[maxn];
ll base = 0, ret = 0;

int main() {
    assert(cin >> n);
    assert(n >= 1 && n <= 1e5);

    for (int i = 2; i <= n; ++i) {
        assert(cin >> tt[i]);
        assert(tt[i] >= 1 && tt[i] <= n);
        assert(i > tt[i]);
    }

    for (int i = 2; i <= n; ++i) {
        assert(cin >> cost[i]);
        assert(cost[i] % 2 == 0);
    }

    cin >> ws;
    assert(cin.eof());

    for (int i = n; i; --i) {
        weight[tt[i]] += (weight[i] += 1);

        ll my_diff = weight[i] * (n - weight[i]) * cost[i];

        base += my_diff;

        ll me = best[i] + my_diff / 2;

        if (best[tt[i]] <= me)
            swap(me, best[tt[i]]);

        if (snd_best[tt[i]] <= me)
            swap(me, snd_best[tt[i]]);

        ret = max(ret, best[i] + snd_best[i]);
    }

    cout << base - ret << endl;

    return 0;
}