#include <bits/stdc++.h>
using namespace std;

constexpr int maxn = 1 << 17;
constexpr int mod = 1e9 + 7;

using state = array<array<long long, 2>, 2>;

int idx = 0;
state evaluate(char a, char b, char c) {
    a -= '0';
    b -= '0';
    c -= '0';
    for (int x = 0; x < 2; ++x)
        for (int y = 0; y < 2; ++y)
            if (a + b + x == c + 10 * y)
                return {1 + (1 - x) * (1 - y), x * (1 - y), (1 - x) * y,
                        1 + x * y};
    return {1, 0, 0, 1};
}

state combine(state a, state b) {
    state ret = {};
    for (int k = 0; k < 2; ++k)
        for (int i = 0; i < 2; ++i)
            for (int j = 0; j < 2; ++j)
                ret[i][j] = (ret[i][j] + a[i][k] * b[k][j]) % mod;
    return ret;
}

int n, q;
string mat[3];
state buf[2 * maxn] = {};

void build() {
    for (int i = 0; i < n; ++i)
        buf[maxn + i] = evaluate(mat[0][i], mat[1][i], mat[2][i]);
    for (int i = n; i < maxn; ++i)
        buf[maxn + i] = {1, 0, 0, 1};

    for (int i = maxn - 1; i > 0; --i)
        buf[i] = combine(buf[2 * i], buf[2 * i + 1]);
}

void update(int i, int j, int c) {
    mat[i][j] = c + '0';

    buf[j + maxn] = evaluate(mat[0][j], mat[1][j], mat[2][j]);
    j += maxn;
    j /= 2;
    for (; j; j /= 2)
        buf[j] = combine(buf[2 * j], buf[2 * j + 1]);
}

int main() {
    assert(cin >> n >> q >> mat[0] >> mat[1] >> mat[2]);

    assert(n <= 100000 && q <= 100000);

    assert(mat[0].size() == n);
    assert(mat[1].size() == n);
    assert(mat[2].size() == n);

    build();
    cout << buf[1][0][0] << '\n';

    while (q--) {
        int i, j, c;
        assert(cin >> i >> j >> c);
        --i, --j;
        update(i, j, c);

        cout << buf[1][0][0] << '\n';
    }

    cin >> ws;
    assert(cin.eof());
}
