#include <iostream>

using namespace std;

//ifstream f("rectangles.in");
//ofstream g("rectangles.out");

using ll = long long;

const int NMAX = 1e6 + 10, LOGMAX = 22;
const int MOD = 1e9 + 7;

int Log2[NMAX];

int N, A[NMAX];
int rmq[LOGMAX][NMAX];

int K, Stiva[NMAX];
int Left[NMAX], Right[NMAX];

static inline void Read ()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    cin >> N;

    for(int i = 1; i <= N; ++i)
    {
        cin >> A[i], rmq[0][i] = A[i];

        if(i > 1)
            Log2[i] = 1 + Log2[(i >> 1)];
    }

    return;
}

static inline int my_max (int a, int b)
{
    return ((a > b) ? a : b);
}

static inline void Build ()
{
    for(int i = 1; i <= Log2[N]; ++i)
    {
        int Lg = (1 << i);

        for(int j = 1; j <= (N - Lg + 1); ++j)
            rmq[i][j] = my_max(rmq[i - 1][j], rmq[i - 1][j + (Lg >> 1)]);
    }

    return;
}

static inline void Load_Stacks ()
{
    for(int i = 1; i <= N; ++i)
    {
        while(K && A[i] >= A[Stiva[K]])
            Right[Stiva[K]] = i, --K;

        Stiva[++K] = i;
    }

    for(int i = 1; i <= K; ++i)
        Right[Stiva[i]] = (N + 1);

    K = 0;

    for(int i = N; i >= 1; --i)
    {
        while(K && A[i] > A[Stiva[K]])
            Left[Stiva[K]] = i, --K;

        Stiva[++K] = i;
    }

    return;
}

static inline int Query (int Left, int Right)
{
    int K = Log2[(Right - Left + 1)];

    return my_max(rmq[K][Left], rmq[K][Right - (1 << K) + 1]);
}

static inline void Solve ()
{
    ll _ans = 0;

    for(int i = 1; i <= N; ++i)
    {
        if(Left[i] != 0)
        {
            int left = 1, right = Left[i] - 1, pos = Left[i];

            while(left <= right)
            {
                int mid = ((left + right) >> 1);

                if(Query(mid, Left[i] - 1) <= A[i])
                    pos = mid, right = mid - 1;
                else
                    left = mid + 1;
            }

            ll Prod = (1LL * A[i] * A[Left[i]]) % (1LL * MOD);
            ll cnt = (1LL * (Left[i] - pos + 1) * (Right[i] - i)) % (1LL * MOD);
            ll Add = (1LL * Prod * cnt) % (1LL * MOD);

            _ans = (_ans + Add) % (1LL * MOD);
        }

        if(Right[i] <= N)
        {
            int left = Right[i] + 1, right = N, pos = Right[i];

            while(left <= right)
            {
                int mid = ((left + right) >> 1);

                if(Query(Right[i] + 1, mid) < A[i])
                    pos = mid, left = mid + 1;
                else
                    right = mid - 1;
            }

            ll Prod = (1LL * A[i] * A[Right[i]]) % (1LL * MOD);
            ll cnt = (1LL * (pos - Right[i] + 1) * (i - Left[i])) % (1LL * MOD);
            ll Add = (1LL * Prod * cnt) % (1LL * MOD);

            _ans = (_ans + Add) % (1LL * MOD);
        }
    }

    cout << _ans << '\n';

    return;
}

int main()
{
    Read();

    Build();

    Load_Stacks();

    Solve();

    return 0;
}
