// O (N * logN)

#include <bits/stdc++.h>

using namespace std;

const int mod = 1e9 + 7, N = 1e6, inf = 1e9;

int v[N + 5], mxR1[N + 5], mxR2[N + 5], sum1[N + 5], areaSum[N + 5];

int divide(int l, int r) {
    if (l == r) return 0;
    int mid = (l + r) / 2;
    int ans = divide(l, mid) + divide(mid + 1, r);
    ans %= mod;
    mxR1[mid + 1] = v[mid + 1];
    sum1[mid + 1] = v[mid + 1];
    mxR2[mid + 1] = -1;
    areaSum[mid + 1] = 0;
    sum1[mid] = areaSum[mid] = 0;
    for (int i = mid + 2; i <= r; ++i) {
        mxR1[i] = mxR1[i - 1];
        mxR2[i] = mxR2[i - 1];
        if (v[i] >= mxR1[i]) {mxR2[i] = mxR1[i]; mxR1[i] = v[i];}
        else if (v[i] > mxR2[i]) mxR2[i] = v[i];
        sum1[i] = (sum1[i - 1] + mxR1[i]) % mod;
        areaSum[i] = (areaSum[i - 1] + ((1LL * mxR1[i] * mxR2[i]) % mod)) % mod;
    }
    int mx1 = -1, mx2 = -1;
    int poz1R2, poz2R1;
    poz1R2 = poz2R1 = mid + 1;
    for (int i = mid; i >= l; --i) {
        if (v[i] >= mx1) {mx2 = mx1; mx1 = v[i];}
        else if (v[i] > mx2) mx2 = v[i];
        while (poz1R2 <= r && mx1 > mxR2[poz1R2]) poz1R2++;
        while (poz2R1 <= r && mx2 > mxR1[poz2R1]) poz2R1++;
        int pct = poz2R1 - 1;
        ans += (1LL * (pct - mid) * ((1LL * mx1 * mx2) % mod)) % mod;
        ans %= mod;
        pct = poz1R2;
        if (pct <= r) ans = (1LL * ans + areaSum[r] - areaSum[pct - 1] + mod) % mod;
        if (poz2R1 < poz1R2) ans = (ans + (1LL * mx1 * (1LL * sum1[poz1R2 - 1] - sum1[poz2R1 - 1] + mod) % mod) % mod) % mod;
    }
    return ans;
}

int main()
{
    //freopen("rectangles.in", "r", stdin);
    //freopen("rectangles.out", "w", stdout);
    //freopen("file.in","r",stdin);
    //freopen("sol.out","w",stdout);
    int n;
    scanf("%d", &n);
    assert(2 <= n && n <= N);
    for (int i = 1; i <= n; ++i) {
        scanf("%d", &v[i]);
        assert(1 <= v[i] && v[i] <= inf);
    }
    printf("%d", divide(1, n));
    return 0;
}
