#include <bits/stdc++.h>
using namespace std;

struct Car {
    int speed;
    int delta;
    int idx;

    bool operator<(const Car& other) const {
        return delta < other.delta ||
               (delta == other.delta && speed > other.speed);
    }
};

bool Q;
struct Line {
    mutable long long k, m, p;
    mutable int idx;
    bool operator<(const Line& o) const { return Q ? p < o.p : k < o.k; }
};

struct LineContainer : multiset<Line> {
    // (for doubles, use inf = 1/.0, div(a,b) = a/b)
    const long long inf = LLONG_MAX;
    long long div(long long a, long long b) {  // floored division
        return a / b - ((a ^ b) < 0 && a % b);
    }
    bool isect(iterator x, iterator y) {
        if (y == end()) {
            x->p = inf;
            return false;
        }
        if (x->k == y->k)
            x->p = x->m > y->m ? inf : -inf;
        else
            x->p = div(y->m - x->m, x->k - y->k);
        return x->p >= y->p;
    }
    void add(long long k, long long m, int idx) {
        auto z = insert({k, m, 0, idx}), y = z++, x = y;
        while (isect(y, z)) z = erase(z);
        if (x != begin() && isect(--x, y)) isect(x, y = erase(y));
        while ((y = x) != begin() && (--x)->p >= y->p) isect(x, erase(y));
    }
    pair<long long, int> query(long long x) {
        assert(!empty());
        Q = 1;
        auto l = *lower_bound({0, 0, x});
        Q = 0;
        return {l.k * x + l.m, l.idx};
    }
};

int main() {
    int numCars, numQueries;
    cin >> numCars >> numQueries;
    vector<Car> cars(numCars);
    int currIdx = 0;
    for (auto& car : cars) {
        cin >> car.delta >> car.speed;
        car.speed = abs(car.speed);
        car.idx = currIdx++;
    }

    sort(cars.begin(), cars.end());
    vector<pair<int, int>> queryDelta(numQueries);
    currIdx = 0;
    for (auto& delta : queryDelta) {
        cin >> delta.first;
        delta.second = currIdx++;
    }
    sort(queryDelta.begin(), queryDelta.end());

    vector<int> queryAnswer(numQueries);
    LineContainer lc[2];
    int maxim = 0;
    auto car = cars.begin();
    for (auto delta : queryDelta) {
        while (car != cars.end() && car->delta <= delta.first) {
            lc[0].add(car->speed, -1LL * car->delta * car->speed, car->idx);
            lc[1].add(-car->speed, 1LL * car->delta * car->speed, car->idx);
            ++car;
        }
        maxim = max(maxim, (int)lc[0].size() + (int)lc[1].size());
        if (lc[0].empty()) {
            queryAnswer[delta.second] = -2;
        } else {
            auto q0 = lc[0].query(delta.first);
            auto q1 = lc[1].query(delta.first);
            queryAnswer[delta.second] =
                q0.first < q1.first ? q0.second : q1.second;
        }
    }

    for (auto ans : queryAnswer) {
        cout << 1 + ans << ' ';
    }

    return 0;
}