#include <iostream>
#include <queue>

using namespace std;

const int NMax = 1505;

bool viz[NMax][NMax];
int tmp[NMax], ans[NMax * NMax];
pair<int, int> src[NMax];

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    int n;
    cin >> n;
    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= n; ++j) {
            int x;
            cin >> x;
            if (x == 1) {
                viz[i][j] = true;
            }
        }
    }

    int m;
    cin >> m;
    for (int i = 0; i < m; ++i) {
        int x, y;
        cin >> x >> y;
        src[i] = {x, y};
    }

    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= n; ++j) {
            if (viz[i][j]) continue;
            int dist = NMax * NMax;
            for (int k = 0; k < m; ++k) {
                dist = min(dist,
                           max(abs(i - src[k].first), abs(j - src[k].second)));
            }
            ++tmp[dist + 1];
        }
    }

    for (int i = 1, idx = 0; i < NMax; ++i) {
        tmp[i] += tmp[i - 1];
        while (idx <= tmp[i]) {
            ans[idx] = i;
            ++idx;
        }
    }

    int t;
    cin >> t;
    while (t--) {
        int x;
        cin >> x;
        cout << ans[x] - 1 << " \n"[t == 0];
    }
    return 0;
}