#include <iostream>
#include <queue>

using namespace std;

const int NMax = 1505;

bool viz[NMax][NMax];
int sum[NMax][NMax];
int tmp[NMax], ans[NMax * NMax];

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    int n;
    cin >> n;
    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= n; ++j) {
            int x;
            cin >> x;
            if (x == 1) {
                viz[i][j] = true;
            }
        }
    }

    int m;
    cin >> m;
    for (int i = 0; i < m; ++i) {
        int x, y;
        cin >> x >> y;
        sum[x][y] = 1;
    }

    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= n; ++j) {
            sum[i][j] =
                sum[i][j] + sum[i - 1][j] + sum[i][j - 1] - sum[i - 1][j - 1];
        }
    }

    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= n; ++j) {
            if (viz[i][j]) continue;
            for (int k = 0; k <= n; ++k) {
                int x = min(n, i + k);
                int y = min(n, j + k);
                int a = max(1, i - k);
                int b = max(1, j - k);
                int have = sum[x][y] - sum[a - 1][y] - sum[x][b - 1] +
                           sum[a - 1][b - 1];
                if (have) {
                    ++tmp[k + 1];
                    break;
                }
            }
        }
    }
    for (int i = 1, idx = 0; i < NMax; ++i) {
        tmp[i] += tmp[i - 1];
        while (idx <= tmp[i]) {
            ans[idx] = i;
            ++idx;
        }
    }

    int t;
    cin >> t;
    while (t--) {
        int x;
        cin >> x;
        cout << ans[x] - 1 << " \n"[t == 0];
    }
    return 0;
}