/*
 * Splatoon - O(N^3)
 * Bogdan Iordache
 */
#include <bits/stdc++.h>
using namespace std;

const int kMaxN = 1505;

int N, M;
int blocked[kMaxN][kMaxN];
pair<int, int> players[kMaxN * kMaxN];

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cin >> N;
    for (int i = 1; i <= N; ++i)
        for (int j = 1; j <= N; ++j) cin >> blocked[i][j];
    cin >> M;
    for (int i = 1; i <= M; ++i) cin >> players[i].first >> players[i].second;

    int current_total = 0;
    vector<int> totals;
    totals.reserve(N);
    for (int t = 0; t < N; ++t) {
        for (int i = 1; i <= M; ++i) {
            int x, y;
            tie(x, y) = players[i];
            if (x - t >= 1) {
                for (int j = max(1, y - t); j <= min(N, y + t); ++j) {
                    current_total += 1 - blocked[x - t][j];
                    blocked[x - t][j] = 1;
                }
            }
            if (x + t <= N) {
                for (int j = max(1, y - t); j <= min(N, y + t); ++j) {
                    current_total += 1 - blocked[x + t][j];
                    blocked[x + t][j] = 1;
                }
            }
            if (y - t >= 1) {
                for (int j = max(1, x - t); j <= min(N, x + t); ++j) {
                    current_total += 1 - blocked[j][y - t];
                    blocked[j][y - t] = 1;
                }
            }
            if (y + t <= N) {
                for (int j = max(1, x - t); j <= min(N, x + t); ++j) {
                    current_total += 1 - blocked[j][y + t];
                    blocked[j][y + t] = 1;
                }
            }
        }
        totals.push_back(current_total);
    }

    int Q;
    cin >> Q;
    for (int i = 1; i <= Q; ++i) {
        int p;
        cin >> p;
        auto it = lower_bound(totals.begin(), totals.end(), p);
        cout << (it == totals.end() ? -1 : it - totals.begin())
             << " \n"[i == Q];
    }

    return 0;
}
