#include <iostream>
#include <queue>

using namespace std;

const int NMax = 1505;
const int dx[] = {-1, -1, -1, 0, 1, 1, 1, 0};
const int dy[] = {-1, 0, 1, 1, 1, 0, -1, -1};

int viz[NMax][NMax];
int tmp[NMax], ans[NMax * NMax];

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    int n;
    cin >> n;
    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < n; ++j) {
            int x;
            cin >> x;
            if (x == 1) {
                viz[i][j] = -1;
            }
        }
    }

    queue<pair<int, int> > q;
    int m;
    cin >> m;
    for (int i = 0; i < m; ++i) {
        int x, y;
        cin >> x >> y;
        --x;
        --y;
        if (viz[x][y] == 0) {
            ++tmp[1];
        }
        viz[x][y] = 1;
        q.push({x, y});
    }

    while (!q.empty()) {
        int x = q.front().first;
        int y = q.front().second;
        q.pop();

        for (int d = 0; d < 8; ++d) {
            int nx = x + dx[d];
            int ny = y + dy[d];
            if (nx < 0 || ny < 0 || nx >= n || ny >= n || viz[nx][ny] > 0) {
                continue;
            }
            if (viz[nx][ny] == 0) {
                ++tmp[viz[x][y] + 1];
            }
            viz[nx][ny] = viz[x][y] + 1;
            q.push({nx, ny});
        }
    }

    for (int i = 1, idx = 0; i < NMax; ++i) {
        tmp[i] += tmp[i - 1];
        while (idx <= tmp[i]) {
            ans[idx] = i;
            ++idx;
        }
    }

    int t;
    cin >> t;
    while (t--) {
        int x;
        cin >> x;
        cout << ans[x] - 1 << " \n"[t == 0];
    }
    return 0;
}