/* Bogdan Iordache
 * O(N*sqrt(VMAX))
 */
#include <bits/stdc++.h>
using namespace std;

int nr_div(int x) {
    int cnt = 1, i;
    for (i = 2; i * i < x; ++i) {
        if (x % i) continue;
        int p = 0;
        while (x % i == 0) {
            x /= i;
            p++;
        }
        cnt *= (p + 1);
    }
    if (x > 1) cnt *= 2;
    return cnt;
}

int mirror(int x) {
    int m = 0;
    while (x) {
        int c = x % 10;
        x /= 10;
        m = m * 10 + c;
    }
    return m;
}

int main() {
#ifndef LOCAL
    ifstream cin("palpow.in");
    ofstream cout("palpow.out");
#endif
    int n;
    cin >> n;
    assert(1 <= n && n <= 1000);

    int cnt = 0, minim = 2000000000, maxim = -1;
    while (n--) {
        int x;
        assert(cin >> x);
        assert(0 <= x && x < 1000000000);

        if (nr_div(x) < nr_div(mirror(x))) {
            minim = min(minim, x);
            maxim = max(maxim, x);
            cnt++;
        }
    }

    assert(cnt);
    cout << cnt << ' ' << minim << ' ' << maxim << '\n';

    return 0;
}
